import pandas as pd   
import matplotlib.pyplot as plt
from decision_company import read_csv_file, logical_and, check_elements_in_list, filter_by_condition, count_unique_values, create_subplots, set_plot_split_title, set_layout, show_plots, save_plot, fetch_column

# Load the dataset      
credit_customers = read_csv_file("credit_customers.csv")  
  
# Plot pie charts      
fig, axes = create_subplots(1, 3, figsize=(18, 6))      
  
approval_rates_middle_aged.plot(kind='pie', ax=axes[0], autopct='%.1f%%', startangle=90, ylabel='')      
set_plot_split_title(axes[0], 'Loan Approval Rates for Middle-Aged Customers (40-59)')      
  
approval_rates_stable_employment.plot(kind='pie', ax=axes[1], autopct='%.1f%%', startangle=90, ylabel='')      
set_plot_split_title(axes[1], 'Loan Approval Rates for Customers with Stable Employment')      
  
approval_rates_good_credit_history.plot(kind='pie', ax=axes[2], autopct='%.1f%%', startangle=90, ylabel='')      
set_plot_split_title(axes[2], 'Loan Approval Rates for Customers with Good/Excellent Credit History')      
  
set_layout()     
save_plot('ref_result/pieplot.png')     
show_plots() 

  